'************************************************************************
'*   File Name      :  2329_iec.bas     Version: 1.0            
'*                                                                
'*   entwickelt von :  M.Westermann     am 26.03.1997             
'*   geaendert von  :  T. Meder  V2.0   am 02.08.2002
'*		       Hinzugefgte Funktionen:
'*		       - Register und Fehlerpuffer vor Messbeginn loeschen
'*		       - Nach Abort auf Messende warten             
'*                                                                
'*   Sprache        :  QBASIC 4.5       Betriebssystem: MS-DOS 6.22
'*                                                                
'*   Beschreibung   :  Programmierbeispiel fr 2329-IEEE488           
'*                                                                
'*   Anmerkung      :  Zum laden der IEEE488-Bus Treiber Library mu das
'*                     QB45-Basic in einer Batch Datei wie folgt auf-
'*                     gerufen werden:                            
'*                     "qb 2329_iec.bas /L c:\AT-GPIB\QBASIC\QBIB.QLB"
'*                     Die Erzeugung der QBIB.QLB ist in der Readme-
'*                     der IEEE-Karte beschrieben.             
'*                     In diesem Beispiel wird die AT-GPIB/TNT von National                                                             
'*                     Instruments benutzt.
'*                                                              
'*   Copyright by burster przisionsmetechnik, Gernsbach 07224-6450
'************************************************************************
  ' Deklaration der verwendeten Funktionen
  DECLARE FUNCTION CmdSenden (id2329%, CMD$)      ' Befehl Senden
  DECLARE FUNCTION CmdEmpfangen (id2329%, antwort$)
  DECLARE FUNCTION AbfrageSRQ (id2329%)  'Status Operation Condition Register abfragen
  DECLARE FUNCTION LeseOperEventReg (id2329%)
  DECLARE FUNCTION LeseQuestReg (id2329%)
  DECLARE FUNCTION LeseQuestFresReg (id2329%)
  DECLARE SUB gpiberr (msg$)

  ' Include-datei fr die IEEE-Karte
  '$INCLUDE: 'c:\at-gpib\qbasic\qbdecl.bas'

  ' Definition der Masken fr die Registerabfragen
  CONST EOC = &H100         ' Bit 8 von Operation Status Register
  CONST FRESError = &H200   ' Bit 9 von Questionable Status Register
  CONST TEMPError = &H10    ' Bit 4 von Questionable Status Register
  CONST SRQOperReg = &H80   ' Bit 7 von SRQ Register
  CONST SRQQuestReg = &H8   ' Bit 3 von SRQ Register
  CONST MEAS = &H10         ' Bit 4 vom Operation Status Register
  CLS                       ' Bildschirm lschen
  PRINT "DEMOPROGRAMM "
  PRINT "burster Resistomat Typ 2329       "
  PRINT "Steuerung ber IEC-Bus Schnittstelle  "
  PRINT
  INPUT "Geben Sie bitte die IEEE488-Adresse des Resistomat Typ 2329 ein: ", adr
  PRINT
  PRINT "Die Messung wird gestartet. Abbruch mit der Leertaste"
  PRINT

  'Der nchsten Befehl ist ein 488.2-Befehl. Diesem Befehl wird als
  'Parameter die Gerteadresse und der Timeout bergegeben.
  'Als Rckgabe erhlt man den Gertehandle (id2329).
  CALL IBDEV(0, adr, 0, T10s, 1, 0, id2329%)
  IF (id2329% < 0) THEN             ' Bei Fehler Fehlerbehandlung aufrufen
	CALL gpiberr("ibdev Error")
	SYSTEM
  END IF

  befehl$ = "abort"         'Gert stoppen falls die Messung luft
  IF (CmdSenden(id2329%, befehl$) = 0) THEN
	 SYSTEM
  END IF

  'Status Operation Condition Register einlesen und warten,
  'bis Messung tatschlich beendet ist
  'Die kann man anhand des Bits MEAS (Bit 4) feststellen
  done = 0
  WHILE (done = 0)
      befehl$ = "S:O:C?"     'Status Operation Condition Register auslesen
      IF (CmdSenden(id2329%, befehl$) = 0) Then   ' Befehl senden
	  END
      END IF
      antwort$ = SPACE$(12)
      IF (CmdEmpfangen(id2329%, antwort$) = 1) THEN   ' Wert einlesen
	  i = VAL(antwort$)
	  IF MEAS AND i Then		 'Bit MEAS ausmaskieren
	     done = 0                    ' MEAS ist TRUE
	  ELSE
	     done = 1                     ' Messung wurde nun beendet (abort)
	  END IF 'MEAS And i Then
      END IF '(CmdEmpfangen(id2329%, antwort$) = 1) Then
  WEND '(done = 0)

  befehl$ = "*CLS"     'Fehlerpuffer loeschen und Register zuruecksetzen
  IF (CmdSenden(id2329%, befehl$) = 0) THEN
	 SYSTEM
  END IF

  'Die folgenden Befehle werden benutzt um den verschiedenen Registern
  'die Masken fr die gewnschte SRQ-Funktion zu setzen
  'Im Status-Operation-Enable-Register BIT8 = EOC als Maske freigeben
  befehl$ = "stat:oper:enab " + STR$(EOC)
  IF (CmdSenden(id2329%, befehl$) = 0) THEN
	 SYSTEM
  END IF

  'Temperatur und Widerstandfehler freigeben
  'Im Status-Questionable-Enable-Register BIT4 = Fehler bei der
  'Temperatur-Messung als Maske und BIT9 = Fehler bei der Widerstands-
  'messung freigeben
  befehl$ = "stat:ques:enab " + STR$(TEMPError OR FRESError)
  IF (CmdSenden(id2329%, befehl$) = 0) THEN
	 SYSTEM
  END IF

  'Im Service-Request-Enable-Register BIT3 = Questionable-Register-Eingang
  'und BIT7 = Operation-Register-Eingang fr einen SRQ freigeben
  befehl$ = "*sre " + STR$(SRQOperReg OR SRQQuestReg)
  IF (CmdSenden(id2329%, befehl$) = 0) THEN
	 SYSTEM
  END IF

 
  befehl$ = "init:cont 0"         'Gert auf Einzelmessung schalten
  IF (CmdSenden(id2329%, befehl$) = 0) THEN
	 SYSTEM
  END IF
 
  i = 0                 ' Zhler zurcksetzen
  DO WHILE (INKEY$ = "") 'Mewerte abfragen bis die Leertaste gedrckt wird
	befehl$ = "in"                              'Eine Messung starten
	IF (CmdSenden(id2329%, befehl$) = 0) THEN   'Befehl Senden
		 SYSTEM
	END IF
	'In der nchsten Schleife wird gewartet bis ein SRQ vorliegt
	'danach wird der Mewert abgeholt
	done% = 0
	DO WHILE (done% <> 1)
		done% = AbfrageSRQ(id2329%)     'SRQ-Register abfragen
		IF (done% = -1) THEN            'im Fehlerfall abbrechen
		  SYSTEM
		END IF
	LOOP

	befehl$ = "fe?"                            'Anforderung Mewert abholen
	IF (CmdSenden(id2329%, befehl$) = 0) THEN  'Befehl Senden
		SYSTEM
	END IF
	antwort$ = SPACE$(12)                ' Buffer unbedingt vorbesetzen
	IF (CmdEmpfangen(id2329%, antwort$) = 1) THEN 'Mewert abholen
		REM LOCATE 15, 3
		PRINT i; " Widerstandswert: "; antwort$  'Mewert anzeigen
		i = i + 1
	ELSE
		SYSTEM
	END IF
  LOOP
END

FUNCTION AbfrageSRQ (id2329%)
'************************************************************************
'Diese Funktion wartet auf einen SRQ am IEC-Bus und ruft dann die
'Service-Funktionen fr den Resistomat auf
'************************************************************************
	DIM befehl$(100)
	DIM stri$(100)

	MASK% = &H4800                     'RQS+TIMO als ibwait Maske setzen
	CALL IBWAIT(id2329%, MASK)
	IF (IBSTA% AND EERR) THEN
		CALL gpiberr("ibwait Error")
		EXIT FUNCTION
	END IF
	CALL IBRSP(id2329%, SPR%)          'Spoll Byte abfragen
	IF (IBSTA% AND EERR) THEN          'im Fehlerfall Fehlerroutine aufrufen
	  AbfrageSRQ = -1                   'Fehler merken
	  CALL gpiberr("ibwait Error")
	  EXIT FUNCTION
	END IF

	SELECT CASE SPR%                    ' nach Spoll Byte verzweigen
		CASE 192
			AbfrageSRQ = 1              ' alles OK
			'Operation Event Register mu abgefragt werden damit es
			'gelscht wird
			status = LeseOperEventReg(id2329%)
		CASE 72, 200                 'Es liegt ein Fehler vor
			AbfrageSRQ = -1          'Fehler merken
			' die nachfolgenden Register mssen ausgelesen werden
			' damit werden sie auch gelscht
			status = LeseOperEventReg(id2329%)
			IF (status > 0) THEN
				PRINT "Gertefehler : Operation Event Register = "; status
			END IF
			status = LeseQuestReg(id2329%)
			IF (status > 0) THEN
				PRINT "Gertefehler : Questionable Register = "; status
			END IF

			status = LeseQuestFresReg(id2329%)
			IF (status > 0) THEN
				PRINT "Gertefehler : Questionable FRes Register = "; status
			END IF
		CASE ELSE
			AbfrageSRQ = 0          ' Weiter warten auf Srq
	END SELECT

END FUNCTION

FUNCTION CmdEmpfangen (id2329%, antwort$)
'************************************************************************
' Antwort vom 2329 Empfangen
'************************************************************************
	DIM help$(100)

	CALL IBRD(id2329%, antwort$)        ' String abholen vom IEC-BUS
	IF (IBSTA% AND EERR) THEN
		CALL gpiberr("ibrd Error")
		antwort$ = ""
		CmdEmpfangen = 0                ' es liegt ein Fehler vor
	ELSE
		L = LEN(antwort$)
		help$ = MID$(antwort$, 1, L - 1) ' LF-Zeichen wegwerfen
		antwort$ = help$
		CmdEmpfangen = 1                ' alles OK
	END IF
END FUNCTION

FUNCTION CmdSenden (id2329%, CMD$)
'************************************************************************
' Kommando zum 2329 senden
'************************************************************************

	DIM msg$(100)

	REM LF$ = CHR$(10)

	msg$ = CMD$ + CHR$(10)  'Befehl zusammensetzen

	CALL IBWRT(id2329%, msg$)       ' Befehl ber IEC-Bus Senden
	IF (IBSTA% AND EERR) THEN
		CALL gpiberr("ibwrt Error")
		CmdSenden = 0               ' Fehler beim Senden
	ELSE
		CmdSenden = 1               ' Alles OK beim Sende
	END IF
END FUNCTION

REM DEFDBL A-Z
SUB gpiberr (msg$) STATIC
' Diese Funktion ist aus dem Basic-Beispiel der National-Instruments-Karte entnommen
'=============================================================================
'                      Subroutine GPIBERR
'  This subroutine will notify you that a NI-488 function failed by printing
'  an error message.  The status variable IBSTA% will also be printed
'  in hexadecimal along with the mnemonic meaning of the bit position.
'  The status variable IBERR% will be printed in decimal along with the
'  mnemonic meaning of the decimal value.  The status variable IBCNT% will
'  be printed in decimal.
'
'  The NI-488 function IBONL is called to disable the hardware and software.
'
'  The STOP command will terminate this program.
'=============================================================================
'

   PRINT msg$

   PRINT "ibsta = &H"; HEX$(IBSTA%); " <";
   IF IBSTA% AND EERR THEN PRINT " ERR";
   IF IBSTA% AND TIMO THEN PRINT " TIMO";
   IF IBSTA% AND EEND THEN PRINT " END";
   IF IBSTA% AND SRQI THEN PRINT " SRQI";
   IF IBSTA% AND RQS THEN PRINT " RQS";
   IF IBSTA% AND SPOLL THEN PRINT " SPOLL";
   IF IBSTA% AND EEVENT THEN PRINT " EVENT";
   IF IBSTA% AND CMPL THEN PRINT " CMPL";
   IF IBSTA% AND LOK THEN PRINT " LOK";
   IF IBSTA% AND RREM THEN PRINT " REM";
   IF IBSTA% AND CIC THEN PRINT " CIC";
   IF IBSTA% AND AATN THEN PRINT " ATN";
   IF IBSTA% AND TACS THEN PRINT " TACS";
   IF IBSTA% AND LACS THEN PRINT " LACS";
   IF IBSTA% AND DTAS THEN PRINT " DTAS";
   IF IBSTA% AND DCAS THEN PRINT " DCAS";
   PRINT " >"
 
   PRINT "iberr = "; IBERR%;
   IF IBERR% = EDVR THEN PRINT " EDVR <DOS Error>"
   IF IBERR% = ECIC THEN PRINT " ECIC <Not CIC>"
   IF IBERR% = ENOL THEN PRINT " ENOL <No Listener>"
   IF IBERR% = EADR THEN PRINT " EADR <Address error>"
   IF IBERR% = EARG THEN PRINT " EARG <Invalid argument>"
   IF IBERR% = ESAC THEN PRINT " ESAC <Not Sys Ctrlr>"
   IF IBERR% = EABO THEN PRINT " EABO <Op. aborted>"
   IF IBERR% = ENEB THEN PRINT " ENEB <No GPIB board>"
   IF IBERR% = EOIP THEN PRINT " EOIP <Async I/O in prg>"
   IF IBERR% = ECAP THEN PRINT " ECAP <No capability>"
   IF IBERR% = EFSO THEN PRINT " EFSO <File sys. error>"
   IF IBERR% = EBUS THEN PRINT " EBUS <Command error>"
   IF IBERR% = ESTB THEN PRINT " ESTB <Status byte lost>"
   IF IBERR% = ESRQ THEN PRINT " ESRQ <SRQ stuck on>"
   IF IBERR% = ETAB THEN PRINT " ETAB <Table Overflow>"
 
   PRINT "ibcnt = "; IBCNT%

END SUB

FUNCTION LeseOperEventReg (id2329%)
'************************************************************************
' Operation Event Register auslesen
'************************************************************************
	DIM befehl$(50)

	befehl$ = "stat:oper?"                     ' Register anfordern
	IF (CmdSenden(id2329%, befehl$) = 0) THEN
		SYSTEM
	END IF

	antwort$ = SPACE$(5)             ' Buffer unbedingt vorbesetzen
	IF (CmdEmpfangen(id2329%, antwort$) = 0) THEN   ' Register  abholen
		SYSTEM
	END IF
	LeseOperEventReg = VAL(antwort$)    ' Rckgabewert bergeben
END FUNCTION

FUNCTION LeseQuestFresReg (id2329%)
'************************************************************************
'Questionable Fres Register auslesen
'************************************************************************
	DIM befehl$(50)

	befehl$ = "stat:ques:fres?"                 'Register anfordern
	IF (CmdSenden(id2329%, befehl$) = 0) THEN
		SYSTEM
	END IF
	antwort$ = SPACE$(4)             ' Buffer unbedingt vorbesetzen
	IF (CmdEmpfangen(id2329%, antwort$) = 0) THEN  ' Register  abholen
		SYSTEM
	END IF

	LeseQuestFresReg = VAL(antwort$)  ' Rckgabewert bergeben
END FUNCTION

FUNCTION LeseQuestReg (id2329%)
'************************************************************************
'Questionable Fres Register auslesen
'************************************************************************
	DIM befehl$(50)

	befehl$ = "stat:ques?"           'Register anfordern
	IF (CmdSenden(id2329%, befehl$) = 0) THEN
		SYSTEM
	END IF

	antwort$ = SPACE$(4)            ' Buffer unbedingt vorbesetzen
	IF (CmdEmpfangen(id2329%, antwort$) = 0) THEN   ' Register  abholen
		SYSTEM
	END IF

	LeseQuestReg = VAL(antwort$)     ' Rckgabewert bergeben
END FUNCTION

